#pragma once

#include <UnitDriveInterface.hpp>
#include <Arduino.h>
#include <SensirionI2cSht3x.h>
#include <Wire.h>
#include <LovyanGFX.hpp>

class SHT3xDrive : public UnitDriveInterface
{
public:
    SHT3xDrive(TwoWire &wire=Wire, lgfx::LGFX_Device *lcd=nullptr);
    ~SHT3xDrive();
    virtual void probe() override;
    virtual void init() override;
    virtual void deinit() override;
    virtual void run() override;
    uint32_t readSerialNumber();
private:
    void onProbeView();
    void onInitView();
    void onInitailizeView();
    void onDeinitView();
    void onRunView();
    lgfx::LGFX_Device *_lcd;
    TwoWire *_wire;
    SensirionI2cSht3x *_sht3x;
    UnitStatus _status = UNIT_STATUS_UNKNOWN;
    float aTemperature;
    float aHumidity;
};